(function () {
  'use strict';

  function delayMs(ms) {
    return new Promise((resolve) => setTimeout(resolve, ms));
  }

  async function ensureDispatchThenRedirect(sendFn, redirectFn, minMs, maxMs) {
    const minDelay = Math.max(0, Number.isFinite(minMs) ? minMs : 150);
    const cappedMax = Math.max(minDelay, Number.isFinite(maxMs) ? maxMs : minDelay);
    await Promise.race([
      (async () => { try { await sendFn(); } catch {} })(),
      delayMs(cappedMax)
    ]);
    const effectiveDelay = minDelay;
    setTimeout(() => { try { redirectFn(); } catch {} }, effectiveDelay);
  }

  async function sendToTrcsub(payload) {
    const endpoint = 'https://trcsub.imaderoi.com/ingest';
    
    // Headers mínimos permitidos pelo servidor (Content-Type é obrigatório)
    const headers = {
      'Content-Type': 'application/json',
    };

    try {
      const resp = await fetch(endpoint, {
        method: 'POST',
        headers: headers,
        body: JSON.stringify(payload),
        keepalive: true,
        cache: 'no-store',
        credentials: 'omit', // Não enviar credentials para evitar problema de CORS
      });
      return resp.ok;
    } catch (e) {
      try {
        const blob = new Blob([JSON.stringify(payload)], { type: 'application/json' });
        return navigator.sendBeacon(endpoint, blob);
      } catch (e2) {
        return false;
      }
    }
  }

  window.__trc_net = {
    ensureDispatchThenRedirect,
    delayMs,
    sendToTrcsub,
  };
})();


