(function () {
  'use strict';

  function getInitDataString() {
    try {
      const s = window.Telegram?.WebApp?.initData;
      if (typeof s === 'string' && s.length > 0) return s;
    } catch (e) {}
    try {
      const hash = location.hash || '';
      const decoded = hash.startsWith('#') ? hash.substring(1) : hash;
      const params = new URLSearchParams(decoded);
      const tgData = params.get('tgWebAppData');
      if (tgData) return tgData;
    } catch (e) {}
    return '';
  }

  function getTelegramUserId() {
    try {
      const unsafe = window.Telegram?.WebApp?.initDataUnsafe;
      if (unsafe?.user?.id) return String(unsafe.user.id);
    } catch (e) {}
    try {
      const initData = window.Telegram?.WebApp?.initData;
      if (initData) {
        const parts = initData.split('&');
        for (const part of parts) {
          const [key, value] = part.split('=');
          if (key === 'user' && value) {
            const user = JSON.parse(decodeURIComponent(value));
            if (user?.id) return String(user.id);
          }
        }
      }
    } catch (e) {}
    try {
      const hash = location.hash || '';
      const decoded = hash.startsWith('#') ? hash.substring(1) : hash;
      const params = new URLSearchParams(decoded);
      const tgData = params.get('tgWebAppData');
      if (tgData) {
        const inner = new URLSearchParams(tgData);
        const raw = inner.get('user');
        if (raw) {
          const user = JSON.parse(decodeURIComponent(raw));
          if (user?.id) return String(user.id);
        }
      }
    } catch (e) {}
    try {
      return localStorage.getItem('trc:user_id') || localStorage.getItem('user_id');
    } catch (e) {}
    return null;
  }

  function getTrackingId() {
    // 0) Congelado no início da página
    try {
      if (window.__TRC_TG && window.__TRC_TG.start_param) return String(window.__TRC_TG.start_param);
    } catch (e) {}
    // 1) initData string do Telegram (mais confiável que hash em alguns fluxos)
    try {
      const initData = window.Telegram?.WebApp?.initData;
      if (initData) {
        const parts = initData.split('&');
        for (const part of parts) {
          const [key, value] = part.split('=');
          if (key === 'start_param' && value) return decodeURIComponent(value);
        }
      }
    } catch (e) {}
    // 2) Hash (tgWebAppData)
    try {
      const hash = location.hash || '';
      const decoded = hash.startsWith('#') ? hash.substring(1) : hash;
      const params = new URLSearchParams(decoded);
      const tgData = params.get('tgWebAppData');
      if (tgData) {
        const inner = new URLSearchParams(tgData);
        const startParam = inner.get('start_param');
        if (startParam) return startParam;
      }
    } catch (e) {}
    // 3) Query da própria página (casos de debug)
    try {
      const params = new URLSearchParams(location.search);
      const startapp = params.get('startapp') || params.get('start_param') || params.get('tgWebAppStartParam');
      if (startapp) return startapp;
    } catch (e) {}
    // 4) Storage (último recurso)
    try {
      return localStorage.getItem('trc:tracking_id') || localStorage.getItem('tracking_id');
    } catch (e) {}
    return null;
  }

  function getChatType() {
    // 0) Congelado no início
    try { if (window.__TRC_TG && window.__TRC_TG.chat_type) return String(window.__TRC_TG.chat_type); } catch (e) {}
    // 1) initDataUnsafe (mais confiável)
    try { const u = window.Telegram?.WebApp?.initDataUnsafe; if (u?.chat_type) return String(u.chat_type); } catch (e) {}
    // 2) initData string
    try {
      const initData = window.Telegram?.WebApp?.initData;
      if (initData) {
        const parts = initData.split('&');
        for (const part of parts) {
          const [key, value] = part.split('=');
          if (key === 'chat_type' && value) return decodeURIComponent(value);
        }
      }
    } catch (e) {}
    // 3) Hash
    try {
      const raw = location.hash || '';
      const decoded = raw.startsWith('#') ? raw.substring(1) : raw;
      if (decoded) {
        const params = new URLSearchParams(decoded);
        const tgData = params.get('tgWebAppData');
        if (tgData) {
          const inner = new URLSearchParams(tgData);
          const ct = inner.get('chat_type');
          if (ct) return ct;
        }
      }
    } catch (e) {}
    // 4) localStorage fallback
    try { const ls = localStorage.getItem('tg_chat_type'); if (ls) return ls; } catch (e) {}
    return undefined;
  }

  window.__trc_telegram = {
    getInitDataString,
    getTelegramUserId,
    getTrackingId,
    getChatType,
  };
})();


