(function () {
  'use strict';

  function nsKey(key) {
    const prefix = (window.__getTrcConfig && window.__getTrcConfig().storage && window.__getTrcConfig().storage.prefix) || 'trc:';
    return `${prefix}${key}`;
  }

  const storage = {
    get(key) {
      try { return localStorage.getItem(nsKey(key)); } catch { return null; }
    },
    set(key, value) {
      try { localStorage.setItem(nsKey(key), value); } catch {}
    },
    remove(key) {
      try { localStorage.removeItem(nsKey(key)); } catch {}
    }
  };

  function generateStrongId() {
    try {
      if (crypto && crypto.randomUUID) return crypto.randomUUID();
      const arr = new Uint8Array(16); crypto.getRandomValues(arr);
      return Array.from(arr, b => b.toString(16).padStart(2, '0')).join('');
    } catch {
      return Date.now().toString(36) + Math.random().toString(36).substring(2, 11);
    }
  }

  function generateTrcId() {
    try {
      const timestamp = Math.floor(Date.now() / 1000);
      const randomPart = Math.random().toString(36).substring(2, 11);
      return `${timestamp}_${randomPart}`;
    } catch {
      return Date.now().toString(36) + Math.random().toString(36).substring(2, 11);
    }
  }

  function getOrCreateTrcId() {
    try {
      const stored = localStorage.getItem('trc:trc_id') || localStorage.getItem('trc_id');
      if (stored) return stored;
      const newId = generateTrcId();
      try {
        localStorage.setItem('trc:trc_id', newId);
      } catch {}
      return newId;
    } catch {
      return generateTrcId();
    }
  }

  function nowUnix() { return Math.floor(Date.now() / 1000); }

  window.__trc_util = {
    storage,
    generateStrongId,
    generateTrcId,
    getOrCreateTrcId,
    nowUnix,
  };
})();


